/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/



package cnrg.itx.datax;

import java.io.*;

/**
 * Interface to abstract a property object. This has to be implemented by any
 * device property class.
 */
public interface Property extends Serializable
{
   /**
    * Finds intersection of compatible properies properties. Otherwise the union
    * @exception DataException thrown when two incompatible properties have been found
    */
   PropertiesCollection merge(PropertiesCollection pc) throws DataException;

   /**
    * Returns the optimal set of properties when merging this property with a properties collection
    * @exception DataException thrown when two incompatible properties have been found
    */
   PropertiesCollection findOptimal(PropertiesCollection pc) throws DataException;  
}
